<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// Include PHPMailer classes
require 'phpmailer/PHPMailer.php';
require 'phpmailer/SMTP.php';
require 'phpmailer/Exception.php';

// Setup log
$logFile = 'webhook-log.txt';
$body = file_get_contents('php://input');
file_put_contents($logFile, "\n=========================\n" . date('c') . "\n Raw Body:\n" . $body . "\n", FILE_APPEND);

// Decode JSON
$data = json_decode($body, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    file_put_contents($logFile, "JSON decode error: " . json_last_error_msg() . "\n", FILE_APPEND);
    http_response_code(400);
    exit("Invalid JSON");
}

// Check for customer email
$email = $data['email'] ?? null;
if (!$email) {
    file_put_contents($logFile, "No customer email found in payload\n", FILE_APPEND);
    http_response_code(400);
    exit("No email");
}

// Order details
$orderName = $data['name'] ?? 'Unknown Order';

// Safely check line items
$lineItems = $data['line_items'] ?? [];
if (!is_array($lineItems)) {
    file_put_contents($logFile, "Line_items missing or invalid format\n", FILE_APPEND);
    http_response_code(400);
    exit("Invalid line_items");
}

$found = false;

foreach ($lineItems as $item) {
        $variantId = $item['variant_id'] ?? null;
        $properties = $item['properties'] ?? [];
        $fileUrl = null;
        
        file_put_contents($logFile, "Checking variant ID: $variantId\n", FILE_APPEND);
        
        // Loop through properties to extract _GTA
        foreach ($properties as $prop) {
            if (isset($prop['name']) && $prop['name'] === '_Image Design') {
                $fileUrl = $prop['value'];
                file_put_contents($logFile, "_GTA property found: $fileUrl\n", FILE_APPEND);
                break;
            }
        }
        
        if ($variantId == 52785563402567 && $fileUrl) {
            file_put_contents($logFile, "Found digital item. Sending to $email\n", FILE_APPEND);

        // Send via SMTP
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'posterlabzz@gmail.com';
            $mail->Password = 'odkhefsmkxcmnckx';
            $mail->SMTPSecure = 'tls'; // or 'ssl'
            $mail->Port = 587;

            $mail->setFrom('posterlabzz@gmail.com', 'Poster Labz');
            $mail->addAddress($email);

            $mail->isHTML(true);
            $mail->Subject = "Your Digital File for Order $orderName";
            $mail->Body = "
                <p>Hi,</p>
                <p>Thank you for your order <strong>$orderName</strong>.</p>
                <p>Your digital file is ready:</p>
                <p><a href='$fileUrl' download style='font-weight:bold;'>Download Your File</a></p>
                <p>Best regards,<br>Poster Labz</p>
            ";

            $mail->send();
            file_put_contents($logFile, "📧 Email sent successfully to $email\n", FILE_APPEND);
            $found = true;
        } catch (Exception $e) {
            file_put_contents($logFile, "PHPMailer error: {$mail->ErrorInfo}\n", FILE_APPEND);
        }
    }
}

if (!$found) {
    file_put_contents($logFile, "No matching digital product or property found in this order\n", FILE_APPEND);
}

http_response_code(200);
echo "Webhook received.";
